% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tipitaka-docs.R, R/tipitaka-package.R
\docType{package}
\name{tipitaka}
\alias{tipitaka}
\title{tipitaka: Data and Tools for Analyzing the Pali Canon}
\description{
The tipitaka package provides access to the complete Pali
Canon, or Tipitaka, from R. The Tipitaka is the canonical
scripture for Theravadin Buddhists worldwide. This package
includes the VRI (Vipassana Research Institute) Chattha
Sangayana edition along with tools for working with Pali text.

Provides access to the complete Pali Canon, or Tipitaka, the canonical scripture for Theravadin Buddhists worldwide. Based on the Chattha Sangayana Tipitaka version 4 (Vipassana Research Institute, 1990). Includes word frequency data and tools for Pali string sorting. For a lemmatized critical edition with sutta-level granularity, see the companion package 'tipitaka.critical'.
}
\section{Datasets}{

\itemize{
  \item tipitaka_raw: the complete text of the Tipitaka (VRI)
  \item tipitaka_names: the names of each book of the Tipitaka
  \item sutta_pitaka: the names of each volume of the Sutta Pitaka
  \item vinaya_pitaka: the names of each volume of the Vinaya Pitaka
  \item abhidhamma_pitaka: the names of each volume of the Abhidhamma Pitaka
  \item pali_alphabet: the complete Pali alphabet in traditional order
  \item pali_stop_words: a set of "stop words" for Pali
}
}

\section{Derived Data}{

These are computed on demand from \code{tipitaka_raw} on first access:
\itemize{
  \item tipitaka_long: word frequencies per volume
  \item tipitaka_wide: word frequency matrix (volumes x words)
}
}

\section{Tools}{

Functions for working with Pali text:
\itemize{
  \item pali_lt: less-than function for Pali strings
  \item pali_gt: greater-than function for Pali strings
  \item pali_eq: equals function for Pali strings
  \item pali_sort: sorting function for vectors of Pali strings
}
}

\section{Related Packages}{

The companion package \pkg{tipitaka.critical} provides a
lemmatized critical edition of the complete Tipitaka based on
a five-witness collation with sutta-level granularity.
}

\author{
\strong{Maintainer}: Dan Zigmond \email{djz@shmonk.com}

}
