% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-normalize.R
\name{normalize_vec}
\alias{normalize_vec}
\alias{normalize_inv_vec}
\title{Normalize to Range (0, 1)}
\usage{
normalize_vec(x, min = NULL, max = NULL, silent = FALSE)

normalize_inv_vec(x, min, max)
}
\arguments{
\item{x}{A numeric vector.}

\item{min}{The population min value in the normalization process.}

\item{max}{The population max value in the normalization process.}

\item{silent}{Whether or not to report the automated \code{min} and \code{max} parameters as a message.}
}
\value{
A \code{numeric} vector with the transformation applied.
}
\description{
Normalization is commonly used to center and scale numeric features to prevent one from
dominating in algorithms that require data to be on the same scale.
}
\details{
\strong{Standardization vs Normalization}
\itemize{
\item \strong{Standardization} refers to a transformation that reduces the range to
mean 0, standard deviation 1
\item \strong{Normalization} refers to a transformation that reduces the min-max range: (0, 1)
}
}
\examples{
library(dplyr)

d10_daily <- m4_daily \%>\% dplyr::filter(id == "D10")

# --- VECTOR ----

value_norm <- normalize_vec(d10_daily$value)
value      <- normalize_inv_vec(value_norm,
                                min = 1781.6,
                                max = 2649.3)

# --- MUTATE ----

m4_daily \%>\%
    group_by(id) \%>\%
    mutate(value_norm = normalize_vec(value))

}
\seealso{
\itemize{
\item Normalization/Standardization: \code{\link[=standardize_vec]{standardize_vec()}}, \code{\link[=normalize_vec]{normalize_vec()}}
\item Box Cox Transformation: \code{\link[=box_cox_vec]{box_cox_vec()}}
\item Lag Transformation: \code{\link[=lag_vec]{lag_vec()}}
\item Differencing Transformation: \code{\link[=diff_vec]{diff_vec()}}
\item Rolling Window Transformation: \code{\link[=slidify_vec]{slidify_vec()}}
\item Loess Smoothing Transformation: \code{\link[=smooth_vec]{smooth_vec()}}
\item Fourier Series: \code{\link[=fourier_vec]{fourier_vec()}}
\item Missing Value Imputation for Time Series: \code{\link[=ts_impute_vec]{ts_impute_vec()}}, \code{\link[=ts_clean_vec]{ts_clean_vec()}}
}
}
