% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regulate_toc.R
\name{regulate_toc}
\alias{regulate_toc}
\alias{regulate_toc_df}
\title{Determine if TOC removal meets Stage 1 DBP Rule requirements}
\usage{
regulate_toc(alk_raw, toc_raw, toc_finished)

regulate_toc_df(
  df,
  alk_raw = "use_col",
  toc_raw = "use_col",
  toc_finished = "use_col"
)
}
\arguments{
\item{alk_raw}{Raw water alkalinity (mg/L as calcium carbonate).}

\item{toc_raw}{Raw water total organic carbon (mg/L).}

\item{toc_finished}{Finished water total organic carbon (mg/L).}

\item{df}{a data frame optionally containing columns for raw water alkalinity, raw water TOC, and finished water TOC}
}
\value{
A data frame containing the TOC removal compliance status.

A data frame with compliance status, removal percent, and optional note columns.
}
\description{
This function takes raw water alkalinity, raw water TOC, and finished water TOC.
It then calculates the TOC removal percentage and checks compliance with the Stage 1 DBP Rule.
}
\details{
The function prints the input parameters and the calculated removal
percentage for TOC. It checks compliance with regulations considering the raw
TOC, alkalinity, and removal percentage. If the conditions are met, it prints
"In compliance"; otherwise, it prints "Not in compliance" and stops execution
with an error message.
}
\examples{
regulate_toc(50, 5, 2)


regulated <- water_df \%>\%
  dplyr::select(toc_raw = toc, alk_raw = alk) \%>\%
  regulate_toc_df(toc_finished = seq(0, 1.2, 0.1))

regulated <- water_df \%>\%
  define_water_df() \%>\%
  chemdose_ph_df(alum = 30, output_water = "dosed") \%>\%
  chemdose_toc_df("dosed") \%>\%
  pluck_water(c("coagulated", "defined"), c("toc", "alk")) \%>\%
  dplyr::select(toc_finished = coagulated_toc, toc_raw = defined_toc, alk_raw = defined_alk) \%>\%
  regulate_toc_df()

}
