% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_report_loci.R
\name{autoplot.qc_report_loci}
\alias{autoplot.qc_report_loci}
\title{Autoplots for \code{qc_report_loci} objects}
\usage{
\method{autoplot}{qc_report_loci}(
  object,
  type = c("overview", "all", "missing", "missing low maf", "missing high maf", "maf",
    "hwe", "significant hwe"),
  maf_threshold = 0.05,
  miss_threshold = 0.01,
  hwe_p = 0.01,
  ...
)
}
\arguments{
\item{object}{an object of class \code{qc_report_loci}}

\item{type}{the type of plot (one of \code{overview}, \code{all}, \code{missing},
\verb{missing low maf}, \verb{missing high maf}, \code{maf}, \code{hwe}, and \verb{significant hwe})}

\item{maf_threshold}{default 0.05, a threshold for the accepted rate of minor
allele frequency of loci}

\item{miss_threshold}{default 0.01, a threshold for the accepted rate of
missingness per loci}

\item{hwe_p}{default 0.01, a threshold of significance for Hardy-Weinberg
exact p-values}

\item{...}{not currently used.}
}
\value{
a \code{ggplot2} object
}
\description{
For \code{qc_report_loci}, the following types of plots are available:
\itemize{
\item \code{overview}: an UpSet plot, giving counts of snps over the threshold for
missingness, minor allele frequency, and Hardy-Weinberg equilibrium P-value,
and visualising the interaction between these
\item \code{all}: a four panel plot, containing \verb{missing high maf}, \verb{missing low maf},
\code{hwe}, and \verb{significant hwe} plots
\item \code{missing}: a histogram of proportion of missing data
\item \verb{missing low maf}: a histogram of the proportion of missing data for
snps with low minor allele frequency
\item \verb{missing high maf}:a histogram of the proportion of missing data for
snps with high minor allele frequency
\item \code{maf}: a histogram of minor allele frequency
\item \code{hwe}: a histogram of HWE exact test p-values
\item \verb{significant hwe}: a histogram of significant HWE exact test p-values
}
}
\details{
\code{autoplot} produces simple plots to quickly inspect an object. They are not
customisable; we recommend that you use \code{ggplot2} to produce publication
ready plots.
}
\examples{
# Create a gen_tibble
bed_file <-
  system.file("extdata", "related", "families.bed", package = "tidypopgen")
example_gt <- gen_tibble(bed_file,
  backingfile = tempfile("families"),
  quiet = TRUE,
  valid_alleles = c("1", "2")
)

loci_report <- example_gt \%>\% qc_report_loci()

# Plot the QC report overview
autoplot(loci_report, type = "overview")

# Plot the QC report all
autoplot(loci_report, type = "all")

# Plot missing data
autoplot(loci_report, type = "missing")

# Plot missing with low maf
autoplot(loci_report, type = "missing low maf", maf_threshold = 0.05)

# Plot missing with high maf
autoplot(loci_report, type = "missing high maf", maf_threshold = 0.05)

# Plot maf
autoplot(loci_report, type = "maf", maf_threshold = 0.05)

# Plot hwe
autoplot(loci_report, type = "hwe", hwe_p = 0.01)

# Plot significant hwe
autoplot(loci_report, type = "significant hwe", hwe_p = 0.01)

}
