% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ild_lag.R
\name{ild_lag}
\alias{ild_lag}
\title{Spacing-aware lag within person}
\usage{
ild_lag(
  x,
  ...,
  n = 1L,
  mode = c("index", "gap_aware", "time_window"),
  max_gap = Inf,
  window = NULL,
  resolution = c("closest_prior", "last_in_window", "mean_in_window")
)
}
\arguments{
\item{x}{An ILD object (see [is_ild()]).}

\item{...}{Variables to lag (tidy-select). Unquoted names or selection.}

\item{n}{Integer. Lag order (default 1 = previous observation).}

\item{mode}{Character. \code{"index"}: row-based lag. \code{"gap_aware"}: same but NA when interval exceeds \code{max_gap}. \code{"time_window"}: value from (time - window, time] with \code{resolution}.}

\item{max_gap}{Numeric. For \code{gap_aware} only. Same units as \code{.ild_time_num}.}

\item{window}{Numeric. For \code{time_window} only: time window width (same units as \code{.ild_time_num}).}

\item{resolution}{Character. For \code{time_window}: \code{"closest_prior"}, \code{"last_in_window"}, or \code{"mean_in_window"}.}
}
\value{
The same ILD tibble with new lag columns. ILD attributes preserved.
}
\description{
Computes lagged values within each person. Use this instead of
[dplyr::lag()], which assumes equal spacing and no gaps and is unsafe
for irregular ILD.
}
