% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_config_set.R
\name{tar_config_set}
\alias{tar_config_set}
\title{Set configuration settings.}
\usage{
tar_config_set(
  inherits = NULL,
  as_job = NULL,
  garbage_collection = NULL,
  label = NULL,
  label_width = NULL,
  level_separation = NULL,
  reporter_make = NULL,
  reporter_outdated = NULL,
  script = NULL,
  seconds_meta_append = NULL,
  seconds_meta_upload = NULL,
  seconds_reporter = NULL,
  seconds_reporter_outdated = NULL,
  seconds_interval = NULL,
  store = NULL,
  shortcut = NULL,
  use_crew = NULL,
  workers = NULL,
  config = Sys.getenv("TAR_CONFIG", "_targets.yaml"),
  project = Sys.getenv("TAR_PROJECT", "main")
)
}
\arguments{
\item{inherits}{Character of length 1, name of the project from which
the current project should inherit configuration settings.
The current project is the \code{project} argument, which
defaults to \code{Sys.getenv("TAR_PROJECT", "main")}.
If the \code{inherits} argument \code{NULL}, the \code{inherits} setting is not modified.
Use \code{\link[=tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{as_job}{Logical of length 1, \code{as_job} argument of \code{\link[=tar_make]{tar_make()}}.
\code{TRUE} to run as an RStudio IDE / Posit Workbench job,
\code{FALSE} to run as a \code{callr} process in the main R session
(depending on the \code{callr_function} argument).
If \code{as_job_} is \code{TRUE}, then the \code{rstudioapi} package must be installed.}

\item{garbage_collection}{Deprecated. Use the \code{garbage_collection}
argument of \code{\link[=tar_option_set]{tar_option_set()}} instead to run garbage collection
at regular intervals in a pipeline, or use the argument of the same
name in \code{\link[=tar_target]{tar_target()}} to activate garbage collection for
a specific target.}

\item{label}{Argument of \code{\link[=tar_glimpse]{tar_glimpse()}} and \code{\link[=tar_visnetwork]{tar_visnetwork()}}
to control node labels.}

\item{label_width}{Argument of \code{\link[=tar_glimpse]{tar_glimpse()}} and \code{\link[=tar_visnetwork]{tar_visnetwork()}}
to control the maximum width (number of characters wide)
of the node labels.}

\item{level_separation}{Argument of \code{\link[=tar_visnetwork]{tar_visnetwork()}} and \code{\link[=tar_glimpse]{tar_glimpse()}}
to control the space between hierarchical levels.}

\item{reporter_make}{Character of length 1, \code{reporter} argument to
\code{\link[=tar_make]{tar_make()}} and related functions that run the pipeline.
If the argument \code{NULL}, the setting is not modified.
Use \code{\link[=tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{reporter_outdated}{Character of length 1, \code{reporter} argument to
\code{\link[=tar_outdated]{tar_outdated()}} and related functions that do not run the pipeline.
If the argument \code{NULL}, the setting is not modified.
Use \code{\link[=tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{script}{Character of length 1, path to the target script file
that defines the pipeline (\verb{_targets.R} by default).
This path should be either
an absolute path or a path relative to the project root where you will
call \code{\link[=tar_make]{tar_make()}} and other functions. When \code{\link[=tar_make]{tar_make()}} and friends
run the script from the current working directory.
If the argument \code{NULL}, the setting is not modified.
Use \code{\link[=tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{seconds_meta_append}{Argument of \code{\link[=tar_make]{tar_make()}}, \code{\link[=tar_make_clustermq]{tar_make_clustermq()}},
and \code{\link[=tar_make_future]{tar_make_future()}}.
Positive numeric of length 1 with the minimum
number of seconds between saves to the local metadata and progress files
in the data store.
This is an aggressive optimization setting not recommended
for most users:
higher values might make the pipeline run faster, but unsaved
work (in the event of a crash) is not up to date.

When the pipeline ends,
all the metadata and progress data is saved immediately,
regardless of \code{seconds_meta_append}.
When the pipeline is just skipping targets, the actual interval
between saves is \code{max(1, seconds_meta_append)} to reduce
overhead.}

\item{seconds_meta_upload}{Argument of \code{\link[=tar_make]{tar_make()}}, \code{\link[=tar_make_clustermq]{tar_make_clustermq()}},
and \code{\link[=tar_make_future]{tar_make_future()}}.
Positive numeric of length 1 with the minimum
number of seconds between uploads of the metadata and progress data
to the cloud
(see \url{https://books.ropensci.org/targets/cloud-storage.html}).
Higher values generally make the pipeline run faster, but unsaved
work (in the event of a crash) may not be backed up to the cloud.
When the pipeline ends,
all the metadata and progress data is uploaded immediately,
regardless of \code{seconds_meta_upload}.}

\item{seconds_reporter}{Deprecated in \code{targets} 1.10.1.9010
(2025-03-31).}

\item{seconds_reporter_outdated}{Deprecated in \code{targets} 1.10.1.9010
(2025-03-31).}

\item{seconds_interval}{Deprecated on 2023-08-24
(\code{targets} version 1.2.2.9001).
Use \code{seconds_meta_append}, \code{seconds_meta_upload},
and \code{seconds_reporter} instead.}

\item{store}{Character of length 1, path to the data store of the pipeline.
If \code{NULL}, the \code{store} setting is left unchanged in the
YAML configuration file (default: \verb{_targets.yaml}).
Usually, the data store lives at \verb{_targets}.
Set \code{store} to a custom directory
to specify a path other than \verb{_targets/}. The path need not exist
before the pipeline begins, and it need not end with "_targets",
but it must be writeable.
For optimal performance, choose a storage location
with fast read/write access.
If the argument \code{NULL}, the setting is not modified.
Use \code{\link[=tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{shortcut}{logical of length 1, default \code{shortcut} argument
to \code{\link[=tar_make]{tar_make()}} and related functions.
If the argument \code{NULL}, the setting is not modified.
Use \code{\link[=tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{use_crew}{Logical of length 1, whether to use \code{crew} in \code{\link[=tar_make]{tar_make()}}
if the \code{controller} option is set in \code{tar_option_set()} in the target
script (\verb{_targets.R}). See \url{https://books.ropensci.org/targets/crew.html}
for details.}

\item{workers}{Positive numeric of length 1, \code{workers} argument of
\code{\link[=tar_make_clustermq]{tar_make_clustermq()}} and related functions that run the pipeline
with parallel computing among targets.
If the argument \code{NULL}, the setting is not modified.
Use \code{\link[=tar_config_unset]{tar_config_unset()}} to delete a setting.}

\item{config}{Character of length 1, file path of the YAML
configuration file with \code{targets} project settings.
The \code{config} argument specifies which YAML configuration
file that \code{tar_config_get()} reads from or \code{tar_config_set()}
writes to in a single function call.
It does not globally change which configuration file is used
in subsequent function calls. The default file path of the YAML
file is always \verb{_targets.yaml} unless you set another
default path using the \code{TAR_CONFIG} environment variable,
e.g. \code{Sys.setenv(TAR_CONFIG = "custom.yaml")}. This also has the
effect of temporarily modifying the default arguments to other functions
such as \code{\link[=tar_make]{tar_make()}} because the default arguments
to those functions are controlled by \code{tar_config_get()}.}

\item{project}{Character of length 1, name of the current
\code{targets} project. Thanks to the \code{config} R package,
\code{targets} YAML configuration files can store multiple
sets of configuration settings, with each set corresponding
to its own project. The \code{project} argument allows you to
set or get a configuration setting for a specific project
for a given call to \code{tar_config_set()} or \code{tar_config_get()}.
The default project is always called \code{"main"}
unless you set another
default project using the \code{TAR_PROJECT} environment variable,
e.g. \code{Sys.setenv(tar_project = "custom")}. This also has the
effect of temporarily modifying the default arguments to other functions
such as \code{\link[=tar_make]{tar_make()}} because the default arguments
to those functions are controlled by \code{tar_config_get()}.}
}
\value{
\code{NULL} (invisibly)
}
\description{
\code{tar_config_set()} writes special custom settings
for the current project to an optional YAML configuration file.
}
\section{Configuration}{

For several key functions like \code{\link[=tar_make]{tar_make()}}, the
default values of arguments are controlled though
\code{tar_config_get()}. \code{tar_config_get()} retrieves data
from an optional YAML configuration file.
You can control the settings in the YAML
file programmatically with \code{tar_config_set()}.
The default file path of this YAML file is \verb{_targets.yaml}, and you can
set another path globally using the \code{TAR_CONFIG}
environment variable. The YAML file can store configuration
settings for multiple projects, and you can globally
set the default project with the \code{TAR_PROJECT} environment
variable.
The structure of the YAML file
follows rules similar to the \code{config} R package, e.g.
projects can inherit settings from one another using the \code{inherits} field.
Exceptions include:
\enumerate{
\item There is no requirement to have a configuration named \code{"default"}.
\item Other projects do not inherit from the default project` automatically.
\item Not all fields need values because \code{targets} already has defaults.
}

\code{targets} does not actually invoke
the \code{config} package. The implementation in \code{targets}
was written from scratch without viewing or copying any
part of the source code of \code{config}.
}

\section{Storage access}{

Several functions like \code{tar_make()}, \code{tar_read()}, \code{tar_load()},
\code{tar_meta()}, and \code{tar_progress()} read or modify
the local data store of the pipeline.
The local data store is in flux while a pipeline is running,
and depending on how distributed computing or cloud computing is set up,
not all targets can even reach it. So please do not call these
functions from inside a target as part of a running
pipeline. The only exception is literate programming
target factories in the \code{tarchetypes} package such as \code{tar_render()}
and \code{tar_quarto()}.
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script(list(tar_target(x, 1 + 1)))
tar_config_get("store") # NULL (data store defaults to "_targets/")
store_path <- tempfile()
tar_config_set(store = store_path)
tar_config_get("store") # Shows a temp file.
tar_make() # Writes to the custom data store identified in _targets.yaml.
tar_read(x) # tar_read() knows about _targets.yaml too.
file.exists("_targets") # FALSE
file.exists(store_path) # TRUE
})
}
}
\seealso{
Other configuration: 
\code{\link{tar_config_get}()},
\code{\link{tar_config_projects}()},
\code{\link{tar_config_unset}()},
\code{\link{tar_config_yaml}()},
\code{\link{tar_envvars}()},
\code{\link{tar_option_get}()},
\code{\link{tar_option_reset}()},
\code{\link{tar_option_set}()},
\code{\link{tar_option_with}()}
}
\concept{configuration}
