% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust-numeric-range.R
\name{adjust_numeric_range}
\alias{adjust_numeric_range}
\title{Truncate the range of numeric predictions}
\usage{
adjust_numeric_range(x, lower_limit = -Inf, upper_limit = Inf)
}
\arguments{
\item{x}{A \code{\link[=tailor]{tailor()}}.}

\item{upper_limit, lower_limit}{A numeric value, NA (for no truncation) or
\code{\link[hardhat:tune]{hardhat::tune()}}.}
}
\value{
An updated \code{\link[=tailor]{tailor()}} containing the new operation.
}
\description{
Truncating ranges involves limiting the output of a model to a specific
range of values, typically to avoid extreme or unrealistic predictions.
This technique can help improve the practical applicability of a model's
outputs by constraining them within reasonable bounds based on domain
knowledge or physical limitations.
}
\section{Data Usage}{

This adjustment doesn't require estimation and, as such, the same data that's
used to train it with \code{fit()} can be predicted on with \code{predict()}; fitting
this adjustment just collects metadata on the supplied column names and does
not risk data leakage.
}

\examples{
\dontshow{if (rlang::is_installed(c("probably"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(tibble)

# create example data
set.seed(1)
d <- tibble(y = rnorm(100), y_pred = y/2 + rnorm(100))
d

# specify calibration
tlr <-
  tailor() |>
  adjust_numeric_range(lower_limit = 1)

# train tailor by passing column names.
tlr_fit <- fit(tlr, d, outcome = y, estimate = y_pred)

predict(tlr_fit, d)
\dontshow{\}) # examplesIf}
}
