% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get_confessional_timing}
\alias{get_confessional_timing}
\title{Confessional time}
\usage{
get_confessional_timing(x, .vs, .episode, .mda = 3)
}
\arguments{
\item{x}{Either a data frame or path(s) to the csv file containing all the time stamps from the Shiny app}

\item{.vs}{Version season}

\item{.episode}{Episode}

\item{.mda}{Missing duration adjustment (MDA) in seconds. If either start or stop is missing from the
records, the missing value is imputed with a 3 second adjustment by default.}
}
\value{
data frame
}
\description{
Takes the output of the times recorded from the Shiny app and aggregates to the final
confessional times and confessional counts. \code{confessional_time} is the total duration
in seconds for the episode. \code{confessional_count} is the number of confessionals
recorded to be at least 10 seconds apart.
}
\examples{
# After running app and recording confessionals, run...
# Example from a saved timing file

library(readr)

path <- system.file(package = "survivoR", "extdata/US4412.csv")
df_us4412 <- read_csv(path)
get_confessional_timing(df_us4412, .vs = "US44", .episode = 12)
}
