% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.ci.icc}
\alias{size.ci.icc}
\title{Sample size for a intraclass correlation confidence interval}
\usage{
size.ci.icc(alpha, icc, r, w)
}
\arguments{
\item{alpha}{alpha value for 1-alpha confidence}

\item{icc}{intraclass correlation planning value}

\item{r}{number of measurements (raters, forms, occasions)}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate an intraclass correlation
with desired confidence interval precision. This type of intraclass
correlation can be used to describe the reliability of a single measurement
(e.g., a single rater or a single form of a test). This intraclass
correlation assumes a two-factor (subject x measurement) model. Use the
size.ci.cronbach function to determine the sample size required to
estimate the reliability of a sum or average of r measurements (e.g., items)
with desired confidence interval precision.
}
\details{
Specifying an intraclass correlation planning value for a conservatively
large sample size requirement is not straightforward with an intraclass
correlation. For r = 2, the sample size requirement is largest for an
intraclass correlation of zero. But for r = 3, 4, 5, 10, 20, and 40 an
intraclass correlation planning value of about .26, .33, .38, .43, .44,
and .45, respectively, maximizes the sample size requirement.
}
\examples{
size.ci.icc(.05, .70, 3, .2)

# Should return:
# Sample size
#          68
 

}
\references{
\insertRef{Bonett2002b}{statpsych}
}
