% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn_graph.R
\name{knn_graph}
\alias{knn_graph}
\title{K-nearest neighbors graph}
\usage{
knn_graph(mat, k, weighted = FALSE)
}
\arguments{
\item{mat}{A matrix to be compared column-by-column.}

\item{k}{How many nearest neighbors to collect.}

\item{weighted}{By default, a binary edge is made between a node and each of
it's \code{k} closest nodes. Set \code{weighted} to \code{TRUE} to weigh each edge by the
similarity (inverse of euclidean distance).}
}
\value{
A directed sparse adjacency matrix with \code{k * ncol(mat)} nonzero
edges. Each column has k edges connected to the k closest columns (not
including itself).
}
\description{
Create a directed sparse graph with edges to each nodes \code{k} nearest
neighbors. Nearness is calculated as the inverse of the euclidean distance
between two columns.
}
\examples{
# Simple random graph
mat <- matrix(runif(100) > 0.75, nrow = 5)
knn_graph(mat, 3)

## Don't run because loading data is slow.
\donttest{
if (requireNamespace("scRNAseq") &&
  requireNamespace("SummarizedExperiment")) {
  # Single Cell RNA data
  library(Matrix)

  expression <- scRNAseq::FletcherOlfactoryData()
  cell_types <- expression$cluster_id

  ## Filter genes with low expression. Remove any genes with less than 10
  ## cells with with any reads.
  counts <- SummarizedExperiment::assay(expression, "counts")
  indices <- rowSums(counts > 0) > 10
  counts <- counts[indices, ]

  ## Normalize by shifted logarithm
  target <- median(colSums(counts))
  size_factors <- colSums(counts) / target
  counts_norm <- log(t(t(counts) / size_factors + 1))

  ## Dimension reduction
  counts_norm <- t(prcomp(t(counts_norm), scale. = FALSE)$x)[1:50, ]

  adj <- knn_graph(counts_norm, 10)
}
}
}
