% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_interface.R
\name{sdf_partition_sizes}
\alias{sdf_partition_sizes}
\title{Compute the number of records within each partition of a Spark DataFrame}
\usage{
sdf_partition_sizes(x)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}
}
\description{
Compute the number of records within each partition of a Spark DataFrame
}
\examples{

\dontrun{
library(sparklyr)
sc <- spark_connect(master = "spark://HOST:PORT")
example_sdf <- sdf_len(sc, 100L, repartition = 10L)
example_sdf \%>\%
  sdf_partition_sizes() \%>\%
  print()
}

}
