% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcmc.R
\name{gcmc}
\alias{gcmc}
\alias{gcmc,sf-method}
\alias{gcmc,SpatRaster-method}
\title{geographical cross mapping cardinality}
\usage{
\S4method{gcmc}{sf}(
  data,
  cause,
  effect,
  libsizes = NULL,
  E = 3,
  tau = 1,
  k = pmin(E^2),
  lib = NULL,
  pred = NULL,
  style = 1,
  dist.metric = "L2",
  nb = NULL,
  threads = detectThreads(),
  parallel.level = "low",
  bidirectional = TRUE,
  detrend = FALSE,
  progressbar = TRUE
)

\S4method{gcmc}{SpatRaster}(
  data,
  cause,
  effect,
  libsizes = NULL,
  E = 3,
  tau = 1,
  k = pmin(E^2),
  lib = NULL,
  pred = NULL,
  style = 1,
  dist.metric = "L2",
  threads = detectThreads(),
  parallel.level = "low",
  bidirectional = TRUE,
  detrend = FALSE,
  progressbar = TRUE
)
}
\arguments{
\item{data}{observation data.}

\item{cause}{name of causal variable.}

\item{effect}{name of effect variable.}

\item{libsizes}{(optional) number of spatial units used.}

\item{E}{(optional) embedding dimensions.}

\item{tau}{(optional) step of spatial lags.}

\item{k}{(optional) number of nearest neighbors.}

\item{lib}{(optional) libraries indices.}

\item{pred}{(optional) predictions indices.}

\item{style}{(optional) embedding style (\code{0} includes current state, \code{1} excludes it).}

\item{dist.metric}{(optional) distance metric (\code{L1}: Manhattan, \code{L2}: Euclidean).}

\item{nb}{(optional) neighbours list.}

\item{threads}{(optional) number of threads to use.}

\item{parallel.level}{(optional) level of parallelism, \code{low} or \code{high}.}

\item{bidirectional}{(optional) whether to examine bidirectional causality.}

\item{detrend}{(optional) whether to remove the linear trend.}

\item{progressbar}{(optional) whether to show the progress bar.}
}
\value{
A list
\describe{
\item{\code{xmap}}{cross mapping results}
\item{\code{cs}}{causal strength}
\item{\code{varname}}{names of causal and effect variable}
\item{\code{bidirectional}}{whether to examine bidirectional causality}
}
}
\description{
geographical cross mapping cardinality
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg", package="spEDM"))
\donttest{
g = gcmc(columbus,"hoval","crime",E = 7,k = 18)
g
}
}
