% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_form_variance_share_fun.R
\name{risk_eval_fun}
\alias{risk_eval_fun}
\title{Evaluate node risk under sampled parameters}
\usage{
risk_eval_fun(
  cyclo_sc,
  indeg_sc,
  btw_sc,
  sample_matrix,
  risk_form = c("additive", "power_mean"),
  eps = 1e-12
)
}
\arguments{
\item{cyclo_sc, indeg_sc, btw_sc}{Numeric scalars. Scaled node metrics (typically
in \eqn{[0,1]}) for cyclomatic complexity, in-degree, and betweenness.}

\item{sample_matrix}{Numeric matrix or data.frame containing sampled parameters.
Must include \code{alpha}, \code{beta}, \code{gamma}. If \code{risk_form = "power_mean"}, must also
include \code{p}.}

\item{risk_form}{Character. One of \code{"additive"} or \code{"power_mean"}.}

\item{eps}{Numeric. Small positive constant \eqn{\epsilon} used to avoid
\eqn{\log(0)} in the \eqn{p \to 0} case. Default \code{1e-12}.}
}
\value{
A numeric vector of risk values, one per row of \code{sample_matrix}.
}
\description{
Internal helper used by \code{\link[=risk_form_variance_share_fun]{risk_form_variance_share_fun()}} to evaluate node risk
for a single node (with scaled inputs) across a sampled parameter matrix.
}
\details{
For \code{risk_form = "additive"}, risk is computed as a weighted sum:

\deqn{r = \alpha\,\tilde{C} + \beta\,\tilde{d}^{\mathrm{in}} + \gamma\,\tilde{b}\,,}

where \eqn{\tilde{C}}, \eqn{\tilde{d}^{\mathrm{in}}}, and \eqn{\tilde{b}} are
scaled cyclomatic complexity, in-degree, and betweenness, respectively.

For \code{risk_form = "power_mean"}, risk is computed as a weighted power mean with
exponent \eqn{p \in [-1, 2]}:

\deqn{r =
\left(\alpha\,\tilde{C}^{p} + \beta\,(\tilde{d}^{\mathrm{in}})^{p} + \gamma\,\tilde{b}^{p}\right)^{1/p}\,.}

In the limit \eqn{p \to 0}, the implementation uses the weighted geometric mean
with a small constant \eqn{\epsilon} to ensure numerical stability:

\deqn{r = \exp\left(\alpha\log(\max(\tilde{C},\epsilon)) +
\beta\log(\max(\tilde{d}^{\mathrm{in}},\epsilon)) +
\gamma\log(\max(\tilde{b},\epsilon))\right)\,.}
}
\keyword{internal}
