% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liMCMC.R
\name{gibbsStepLi}
\alias{gibbsStepLi}
\title{Gibbs Step Li - One MCMC step for the Li Model}
\usage{
gibbsStepLi(ijDat, iDat, kappa, gamma, alpha, beta, S, indFirst)
}
\arguments{
\item{ijDat}{A data.frame with parameters at the individual-observation level: Individual, ys, lambdais, piis, ss.}

\item{iDat}{A data.frame with parameters at the individual level: Individual, lambdas, pis.}

\item{kappa}{Fixed value of hyperparameter kappa.}

\item{gamma}{Fixed value of hyperparameter gamma.}

\item{alpha}{Fixed value of hyperparameter alpha.}

\item{beta}{Fixed value of hyperparamter beta.}

\item{S}{Fixed input value S.}

\item{indFirst}{A logical vector indicating the first occurrence of each individual.}
}
\value{
A list containing one MCMC draws for each parameter. Elements are:
\describe{
\item{ijDat}{A data.frame with updated parameters at the individual-observation level: Individual, ys, lambdais, piis, ss.}
\item{iDat}{A data.frame with updated parameters at the individual level: Individual, lambdas, pis.}
\item{kappa}{Fixed value of hyperparameter kappa.}
\item{gamma}{Fixed value of hyperparameter gamma.}
\item{alpha}{Fixed value of hyperparameter alpha.}
\item{beta}{Fixed value of hyperparamter beta.}
\item{S}{Fixed input value S.}
\item{indFirst}{A logical vector indicating the first occurrence of each individual.}
}
}
\description{
Gibbs Step Li - One MCMC step for the Li Model
}
\references{
Li, Kathy, et al. "A predictive model for next cycle start date that accounts for adherence in menstrual self-tracking." Journal of the American Medical Informatics Association 29.1 (2022): 3-11.
}
