% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_config.R
\name{create_config}
\alias{create_config}
\title{Create a list of configuration settings for some details of \code{\link[=sim_linelist]{sim_linelist()}}}
\usage{
create_config(...)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Named elements to replace
default settings. Only if names match exactly are elements replaced,
otherwise the function errors.

Accepted arguments and their defaults are:

\describe{
\item{\code{last_contact_distribution}}{A \code{function} to generate the
time for last contact. Default parameterisation is a Poisson
distribution with a \eqn{\lambda} of 3.}
\item{\code{first_contact_distribution}}{A \code{function} to generate the time
for the first contact. Default parameterisation is a Poisson
distribution with a \eqn{\lambda} of 3.}
\item{\code{ct_distribution}}{A \code{function} to generate Ct values for each
confirmed case. Default parameterisation is a Normal distribution with
a mean (\eqn{\mu}) of 25 and a standard deviation (\eqn{\sigma}) of 2.}
\item{\code{network}}{A \code{character} string, either \code{"adjusted"} (default) or
\code{"unadjusted"}.}
\item{\code{time_varying_death_risk}}{By default is \code{NULL}, but can also accept
a \code{function} with two arguments, \code{risk} and \code{time}, to apply a
time varying death risk of hospitalised and non-hospitalised cases in
the outbreak simulation. See
\code{vignette("time-varying-cfr", package = "simulist")}.}
\item{\code{prob_male}}{By default is 0.5, so there is a equal probability of
each case or contact being male or female. The value must be non-negative
and less than or equal to 1. Smaller values will result in a higher
probability of female contacts and cases (1 - \code{prob_male}).}
}}
}
\value{
A list of settings for \code{\link[=sim_linelist]{sim_linelist()}}.
}
\description{
Create a list of configuration settings for some details of \code{\link[=sim_linelist]{sim_linelist()}}
}
\details{
The \code{config} argument in \code{\link[=sim_linelist]{sim_linelist()}} controls the small details
around time windows around infections (time of first contact and last
contact with infector), and the distribution of the Cycle threshold (Ct)
value from a Real-time PCR or quantitative PCR (qPCR) for confirmed
cases, the network effect in the simulation, and if there is a time-varying
death risk, as well as the probability of a case or contact being
male/female.

These parameters do not warrant their own arguments in
\code{\link[=sim_linelist]{sim_linelist()}} as they rarely need to be changed from their default
setting. Therefore it is not worth increasing the number of \code{\link[=sim_linelist]{sim_linelist()}}
arguments to accommodate these and the \code{config} argument keeps the function
signature simpler and more readable.

The \code{last_contact_distribution} and \code{first_contact_distribution} can accept
any function that generates positive integers (e.g. discrete probability
distribution, \code{\link[=rpois]{rpois()}} or \code{\link[=rgeom]{rgeom()}}). The \code{ct_distribution} can accept
any function that generates real numbers (e.g. continuous or discrete
probability distribution, \code{\link[=rnorm]{rnorm()}}, \code{\link[=rlnorm]{rlnorm()}}).

The \code{network} option controls whether to sample contacts from a adjusted or
unadjusted contact distribution. Adjusted (default) sampling uses
\eqn{q(n) \sim (n + 1)p(n + 1)} where \eqn{p(n)} is the probability
density function of a distribution, e.g., Poisson or Negative binomial.
Unadjusted (\code{network = "unadjusted"}) instead samples contacts directly from
a probability distribution \eqn{p(n)}.
}
\examples{
# example with default configuration
create_config()

# example with customised Ct distribution
create_config(
  ct_distribution = function(n) rlnorm(n = n, meanlog = 2, sdlog = 1)
)
}
