% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.model.R
\name{RW}
\alias{RW}
\title{Create an Random Walk (RW) Process}
\usage{
RW(gamma2 = NULL)
}
\arguments{
\item{gamma2}{A \code{double} value for the variance \eqn{\gamma ^2}{gamma^2}}
}
\value{
An S3 object with called ts.model with the following structure:
\describe{
 \item{process.desc}{Used in summary: "RW"}
 \item{theta}{\eqn{\sigma}{sigma}}
 \item{plength}{Number of parameters}
 \item{print}{String containing simplified model}
 \item{desc}{y desc replicated x times}
 \item{obj.desc}{Depth of parameters e.g. list(1)}
 \item{starting}{Guess starting values? TRUE or FALSE (e.g. specified value)}
}
}
\description{
Sets up the necessary backend for the RW process.
}
\note{
We consider the following model: \deqn{Y_t = \sum\nolimits_{t=0}^{T} \gamma_0*Z_t} where \eqn{Z_t} is iid 
and follows a standard normal distribution.
}
\examples{
RW()
RW(gamma2=3.4)
}
\author{
James Balamuta
}
