% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inframe.R
\name{sim_inframe}
\alias{sim_inframe}
\title{Calculate prob for study sites using table operations}
\usage{
sim_inframe(df_visit, r = 1000, df_site = NULL, event_names = c("ae"))
}
\arguments{
\item{df_visit}{Data frame with columns: study_id, site_number, patnum, visit,
n_ae.}

\item{r}{Integer or tbl_object, number of repetitions for bootstrap
simulation. Pass a tbl object referring to a table with one column and as
many rows as desired repetitions. Default: 1000.}

\item{df_site, }{dataframe as returned be \code{\link[=site_aggr]{site_aggr()}}, Will switch to visit_med75.
Default: NULL}

\item{event_names}{vector, contains the event names, default = "event"}
}
\description{
Calculate prob for study sites using table operations
}
\examples{
df_visit <- sim_test_data_study(
  n_pat = 100,
  n_sites = 5,
  ratio_out = 0.4,
  factor_event_rate = - 0.6
) \%>\%
dplyr::rename(
  site_number = site_id,
  patnum = patient_id,
  n_ae = n_event
)

df_sim <- simaerep:::sim_inframe(df_visit)
}
