% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simaerep.R
\name{check_df_visit}
\alias{check_df_visit}
\title{Integrity check for df_visit.}
\usage{
check_df_visit(df_visit, event_names = c("event"))
}
\arguments{
\item{df_visit}{dataframe with columns: study_id, site_number, patnum, visit,
n_ae}

\item{event_names}{vector, contains the event names, default = "ae"}
}
\value{
corrected df_visit
}
\description{
Internal function used by all functions that accept df_visit as a parameter.
Checks for NA columns, numeric visits and AEs, implicitly missing and
duplicated visits.
}
\examples{

df_visit <- sim_test_data_study(
  n_pat = 100,
  n_sites = 5,
  ratio_out = 0.4,
  factor_event_rate = 0.6
  ) \%>\%
  # internal functions require internal column names
  dplyr::rename(
    site_number = site_id,
    patnum = patient_id
  )

df_visit_filt <- df_visit \%>\%
  dplyr::filter(visit != 3)

df_visit_corr <- check_df_visit(df_visit_filt)
3 \%in\% df_visit_corr$visit
nrow(df_visit_corr) == nrow(df_visit)

df_visit_corr <- check_df_visit(dplyr::bind_rows(df_visit, df_visit))
nrow(df_visit_corr) == nrow(df_visit)

}
\seealso{
\link[=simaerep]{simaerep}
}
\keyword{internal}
