% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IRT.R
\name{obsirt}
\alias{obsirt}
\title{Simulate responses according to IRT probabilities}
\usage{
obsirt(myp)
}
\arguments{
\item{myp}{Object of class \code{mpirt} containing the expected IRT probabilities obtained with function \code{mpirt()}}
}
\description{
Simulate responses according to IRT probabilities
}
\examples{
set.seed(123)
n <- 50
theta <- rnorm(500)
item_par <- data.frame(
  b = runif(n, -3, 3),
  a = runif(n, 1.2, 1.9),
  c = rep(0, n),
  e = rep(1, n)
)
expected_prob <- mpirt(item_par, theta)
simulated_responses <- obsirt(expected_prob)
}
