% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launch_shinybrms.R
\name{launch_shinybrms}
\alias{launch_shinybrms}
\title{Launch the \bold{shinybrms} app}
\usage{
launch_shinybrms(...)
}
\arguments{
\item{\dots}{Arguments passed to \code{\link[shiny:runApp]{shiny::runApp()}}. For example, in order to
force the \bold{shinybrms} app to launch in the system's default web
browser (e.g., if using RStudio), set argument \code{launch.browser} to \code{TRUE}.}
}
\value{
\code{TRUE} (invisible).
}
\description{
This function launches the \bold{shinybrms} app.
}
\note{
The following global options are introduced by \bold{shinybrms}:
\itemize{
\item \code{shinybrms.allow_upd}: Mainly for internal testing purposes. A single
logical value indicating whether updating a previous model fit using
\code{brms:::update.brmsfit()} is allowed. Defaults to \code{TRUE}.
\item \code{shinybrms.prog_browser}: The value for the global option \code{browser} to be
used for opening the \href{https://mc-stan.org/}{Stan} progress file (an HTML
file). Defaults to option \code{browser} (see \code{\link[base:options]{base::options()}}). Note that
RStudio's default for option \code{browser} cannot be used for the Stan progress
file. Therefore, \bold{shinybrms} automatically redefines RStudio's default
for option \code{browser} to fix this issue.
\item \code{shinybrms.shinystan_browser}: The value for the global option \code{browser} to
be used for opening the \bold{shinystan} app. Defaults to option \code{browser}
(see \code{\link[base:options]{base::options()}}). Note that RStudio's default for option \code{browser}
cannot be used for opening the \bold{shinystan} app from within
\bold{shinybrms}. Therefore, \bold{shinybrms} automatically redefines
RStudio's default for option \code{browser} to fix this issue.
}

External global options used by \bold{shinybrms} are:
\itemize{
\item \code{shiny.maxRequestSize} (see \code{\link[shiny:shinyOptions]{shiny::shinyOptions()}}): If not specified by
the user, then \bold{shinybrms} uses a value of \code{50 * 1024^2} (corresponding
to 50 MB).
\item \code{warn} (see \code{\link[base:options]{base::options()}}): Set and reset internally (necessary for
capturing some warning messages).
\item \code{browser} (see \code{\link[base:options]{base::options()}}): Set and reset internally (see above).
\item \code{mc.cores} (see \code{\link[base:options]{base::options()}}): If option \code{mc.cores} is set, then the
advanced option "Cores" (in the \bold{shinybrms} app) defaults to the value
of this option. If option \code{mc.cores} is not set, then "Cores" defaults to \code{1}
(i.e., sequential, not parallel computation).
\item \code{brms.backend} (see \code{\link[brms:brm]{brms::brm()}}): If option \code{brms.backend} is set, then
the advanced option "Backend" (in the \bold{shinybrms} app) defaults to the
value of this option. If option \code{brms.backend} is not set, then the advanced
option "Backend" defaults to \code{"rstan"}.
}

Note that \bold{shinystan}'s global option \code{shinystan.rstudio} (see
\code{\link[shinystan:launch_shinystan]{shinystan::launch_shinystan()}}) may not be used here as \bold{shinystan} is
called from an external \R process where RStudio's browsers are not
available.
}
\examples{
if (interactive()) {
  launch_shinybrms(launch.browser = TRUE)
}

}
\references{
Weber F, Ickstadt K, and Glass Ä (2022). \strong{shinybrms}: Fitting Bayesian
Regression Models Using a Graphical User Interface for the R Package
\strong{brms}. \emph{The R Journal} 14(2): 96--120. \doi{10.32614/RJ-2022-027}.
}
