% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods__token.R
\name{revoke_token}
\alias{revoke_token}
\title{Revoke an OAuth 2.0 token}
\usage{
revoke_token(
  oauth_client,
  oauth_token,
  which = c("refresh", "access"),
  async = FALSE,
  shiny_session = NULL
)
}
\arguments{
\item{oauth_client}{\link{OAuthClient} object}

\item{oauth_token}{\link{OAuthToken} object containing tokens to revoke}

\item{which}{Which token to revoke: "refresh" (default) or "access"}

\item{async}{Logical, default FALSE. If TRUE and the \link[mirai:mirai]{mirai::mirai} package is
available, the operation is performed off the main R session using
\code{mirai::mirai()} and this function returns a mirai (which implements
\code{as.promise()}) that resolves to the result list. Requires mirai
daemons to be configured with \code{\link[mirai:daemons]{mirai::daemons()}}.}

\item{shiny_session}{Optional pre-captured Shiny session context (from
\code{capture_shiny_session_context()}) to include in audit events. Used when
calling from async workers that lack access to the reactive domain.}
}
\value{
A list with fields: supported, revoked, status
}
\description{
Attempts to revoke an access or refresh token using RFC 7009 when the
provider exposes a revocation endpoint.

Authentication mirrors the provider's \code{token_auth_style} (same as token
exchange and introspection).

Best-effort semantics:
\itemize{
\item If the provider does not expose a revocation endpoint, returns
\code{supported = FALSE}, \code{revoked = NA}, and \code{status = "revocation_unsupported"}.
\item If the selected token value is missing, returns \code{supported = TRUE},
\code{revoked = NA}, and \code{status = "missing_token"}.
\item If the endpoint returns a 2xx, returns \code{supported = TRUE}, \code{revoked = TRUE},
and \code{status = "ok"}.
\item If the endpoint returns an HTTP error, returns \code{supported = TRUE},
\code{revoked = NA}, and \code{status = "http_<code>"}.
}
}
