% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/providers.R
\name{oauth_provider_spotify}
\alias{oauth_provider_spotify}
\title{Create a Spotify \link{OAuthProvider}}
\usage{
oauth_provider_spotify(name = "spotify")
}
\arguments{
\item{name}{Optional provider name (default "spotify")}
}
\value{
\link{OAuthProvider} object for use with a Spotify OAuth 2.0 app
}
\description{
Pre-configured OAuth 2.0 provider for Spotify.
Uses /v1/me as "userinfo". No ID token (not OIDC).
}
\details{
Spotify requires scopes to be included in the authorization request.
Set requested scopes on the client with \code{oauth_client(..., scopes = ...)}.
}
\examples{
# Configure generic OAuth 2.0 provider (no OIDC)
generic_provider <- oauth_provider(
  name = "example",
  auth_url = "https://example.com/oauth/authorize",
  token_url = "https://example.com/oauth/token",
  # Optional URL for fetching user info:
  userinfo_url = "https://example.com/oauth/userinfo"
)

# Configure generic OIDC provider manually
# (This defaults to using nonce & ID token validation)
generic_oidc_provider <- oauth_provider_oidc(
  name = "My OIDC",
  base_url = "https://my-issuer.example.com"
)

# Configure a OIDC provider via OIDC discovery
# (requires network access)
\donttest{
# Using Auth0 sample issuer as an example
oidc_discovery_provider <- oauth_provider_oidc_discover(
  issuer = "https://samples.auth0.com"
)
}

# GitHub preconfigured provider 
github_provider <- oauth_provider_github()

# Google preconfigured provider
google_provider <- oauth_provider_google()

# Microsoft preconfigured provider
# See `?oauth_provider_microsoft` for example using a custom tenant ID

# Spotify preconfigured provider 
spotify_provider <- oauth_provider_spotify()

# Slack via OIDC discovery
# (requires network access)
\donttest{
slack_provider <- oauth_provider_slack()
}
  
# Keycloak
# (requires configured Keycloak realm; example below is therefore not run)
\dontrun{
oauth_provider_keycloak(base_url = "http://localhost:8080", realm = "myrealm")
}

# Auth0
# (requires configured Auth0 domain; example below is therefore not run)
\dontrun{
oauth_provider_auth0(domain = "your-tenant.auth0.com")
}

# Okta
# (requires configured Okta domain; example below is therefore not run)
\dontrun{
oauth_provider_okta(domain = "dev-123456.okta.com")
}
}
\seealso{
For an example application which using Spotify OAuth 2.0 login to
display the user's listening data, see \code{vignette("example-spotify")}.
}
