% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_regression_separate.R
\name{regression.get_tune}
\alias{regression.get_tune}
\title{Get if model is to be tuned}
\usage{
regression.get_tune(regression.model, regression.tune_values, x_train)
}
\arguments{
\item{regression.model}{A \code{tidymodels} object of class \code{model_specs}. Default is a linear regression model, i.e.,
\code{\link[parsnip:linear_reg]{parsnip::linear_reg()}}. See \href{https://www.tidymodels.org/find/parsnip/}{tidymodels} for all possible models,
and see the vignette for how to add new/own models. Note, to make it easier to call \code{explain()} from Python, the
\code{regression.model} parameter can also be a string specifying the model which will be parsed and evaluated. For
example, \verb{"parsnip::rand_forest(mtry = hardhat::tune(), trees = 100, engine = "ranger", mode = "regression")"}
is also a valid input. It is essential to include the package prefix if the package is not loaded.}

\item{regression.tune_values}{Either \code{NULL} (default), a data.frame/data.table/tibble, or a function.
The data.frame must contain the possible hyperparameter value combinations to try.
The column names must match the names of the tunable parameters specified in \code{regression.model}.
If \code{regression.tune_values} is a function, then it should take one argument \code{x} which is the training data
for the current coalition and returns a data.frame/data.table/tibble with the properties described above.
Using a function allows the hyperparameter values to change based on the size of the coalition See the regression
vignette for several examples.
Note, to make it easier to call \code{\link[=explain]{explain()}} from Python, the \code{regression.tune_values} can also be a string
containing an R function. For example,
\code{"function(x) return(dials::grid_regular(dials::mtry(c(1, ncol(x)))), levels = 3))"} is also a valid input.
It is essential to include the package prefix if the package is not loaded.}

\item{x_train}{Data.table with training data.}
}
\value{
A boolean variable indicating if the regression model is to be tuned.
}
\description{
That is, if the regression model contains hyperparameters we are to tune using cross validation.
See \href{https://www.tidymodels.org/find/parsnip/#model-args}{tidymodels} for default model hyperparameters.
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
