% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pi0_model.R
\name{pi0_model}
\alias{pi0_model}
\title{Build Model for Functional Proportion of Null Tests (fpi0)}
\usage{
pi0_model(
  z,
  indep_snps = NULL,
  fdr_threshold = 0.25,
  min_discoveries = 2500,
  min_snps_per_knot = 100,
  n_knots = 5,
  verbose = TRUE
)
}
\arguments{
\item{z}{Matrix/data.frame of p-values (rows=tests, cols=traits).}

\item{indep_snps}{Logical vector indicating independent SNPs (training subset).
If NULL, uses all tests. Default: NULL.}

\item{fdr_threshold}{FDR threshold for signal definition. Default: 0.25.}

\item{min_discoveries}{Min significant hits required to include trait. Default: 2500.}

\item{min_snps_per_knot}{Min significant SNPs per knot interval. Default: 100. Note that this is the minimum independent SNPs required per knot interval if `indep_snps` is provided.}

\item{n_knots}{Target knot count. Default: 5. Automatically reduced if insufficient
discoveries (via `min_snps_per_knot`) or capped by `max_knots`.}

\item{verbose}{Print selection details. Default: TRUE.}
}
\value{
List containing:
\item{fmod}{Model formula (using \code{splines::ns})}
\item{zt}{Data frame of globally rank-transformed p-values}
}
\description{
Generates a natural spline model for the functional proportion of null tests (fpi0) by
adaptively selecting knots based on an FDR threshold.
}
\details{
Independent SNPs determine knot placement; all SNPs train the model to capture signal shape.
For smaller datasets (<100K), consider reducing `min_snps_per_knot` and `min_discoveries` to improve knot placement.
}
