% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_smart_metrics.R
\name{st_smart_metrics}
\alias{st_smart_metrics}
\title{Smart Metrics Fetching with Automatic ID Resolution}
\usage{
st_smart_metrics(
  app_ids,
  metrics = c("revenue", "downloads"),
  start_date = Sys.Date() - 30,
  end_date = Sys.Date() - 1,
  countries = "WW",
  granularity = "daily",
  auto_resolve = TRUE,
  use_cache = TRUE,
  parallel = TRUE,
  auth_token = Sys.getenv("SENSORTOWER_AUTH_TOKEN"),
  verbose = TRUE
)
}
\arguments{
\item{app_ids}{Character vector. Can be any mix of iOS IDs, Android IDs,
or Sensor Tower unified IDs.}

\item{metrics}{Character vector. Metrics to fetch (e.g., "revenue", "downloads", "dau").}

\item{start_date}{Date or character string. Start date for metrics.}

\item{end_date}{Date or character string. End date for metrics.}

\item{countries}{Character vector. Country codes (default "WW").}

\item{granularity}{Character. Date granularity ("daily", "weekly", "monthly").}

\item{auto_resolve}{Logical. Automatically resolve IDs using cache/API (default TRUE).}

\item{use_cache}{Logical. Use ID cache to minimize lookups (default TRUE).}

\item{parallel}{Logical. Use parallel processing (default TRUE).}

\item{auth_token}{Character string. Your Sensor Tower API authentication token.}

\item{verbose}{Logical. Print progress messages.}
}
\value{
A tibble with metrics in long format
}
\description{
Enhanced metrics fetching that automatically handles ID resolution,
caching, and fallbacks to minimize API calls.
}
\examples{
\dontrun{
# Mixed ID types - automatically resolved
metrics <- st_smart_metrics(
  app_ids = c(
    "553834731", # Candy Crush iOS
    "com.king.candycrushsaga", # Candy Crush Android
    "5ba4585f539ce75b97db6bcb" # Star Trek unified ID
  ),
  metrics = c("revenue", "downloads", "dau"),
  start_date = "2024-01-01",
  end_date = "2024-12-31"
)
}

}
