% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_update.R
\name{scf_update}
\alias{scf_update}
\title{Create or Alter SCF Variables}
\usage{
scf_update(object, ...)
}
\arguments{
\item{object}{A \code{scf_mi_survey} object, typically created by \code{\link[=scf_load]{scf_load()}}.}

\item{...}{Named expressions assigning new or modified variables using \code{=} syntax.
Each expression must return a vector of the same length as the implicate data frame.}
}
\value{
A new \code{scf_mi_survey} object with:
\describe{
\item{implicates}{A list of updated data frames (one per implicate).}
\item{mi_design}{A list of updated \code{svyrep.design} survey objects.}
\item{data}{(If present in the original object) unchanged pooled data.}
}
}
\description{
Use this function to create or alter SCF variables once the raw data set has
been loaded into memory using the \code{scf_load()} function. This function
updates an \code{scf_mi_survey} object by evaluating transformations within each
implicate, and then returning a new object with the new or amended variables.

Most of the time, you can use \code{scf_update()} to define variables based on
simple logical conditions, arithmetic transformations, or categorical
binning. These rules are evaluated separately in each implicate, using the
same formula. However, if the transformation you want to apply depends on the
distribution of the data within each implicate, such as computing an
average percentile or ranking households across all implicates,
this function will not suffice. In those cases, use
\code{\link[=scf_update_by_implicate]{scf_update_by_implicate()}} to write a custom function that operates on each
implicate individually.
}
\section{Usage}{

Use \code{scf_update()} during data wrangling to clean, create, or alter variables before calculating
statistics or running models. The function is useful when the analyst wishes to:
\itemize{
\item Recode missing values that are coded as numeric data
\item Recast variables that are not in the desired format (e.g., converting a numeric variable to a factor)
\item Create new variables based on existing ones (e.g., calculating ratios, differences, or indicators)
}
}

\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td <- tempfile("update_")
dir.create(td)

src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Example for real analysis: Create a binary indicator for being over age 50
scf2022 <- scf_update(scf2022,
  over50 = age > 50
)

# Example: Create a log-transformed income variable
scf2022 <- scf_update(scf2022,
  log_income = log(income + 1)
)

# Do not implement these lines in real analysis: Cleanup for package check
unlink(td, recursive = TRUE, force = TRUE)

}
\seealso{
\code{\link[=scf_load]{scf_load()}}, \code{\link[=scf_update_by_implicate]{scf_update_by_implicate()}}, \code{\link[survey:svrepdesign]{survey::svrepdesign()}}
}
