% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_linear_power.R
\name{lin_pow}
\alias{lin_pow}
\title{Fit the log-log version of the power model}
\usage{
lin_pow(data, con = 1, logT = log, compare = FALSE, normaTest =
  "none", homoTest = "none", homoCor = "spearman")
}
\arguments{
\item{data}{A dataset in the form of a dataframe with two columns: the first
with island/site areas, and the second with the species richness of each
island/site.}

\item{con}{The constant to add to the species richness values in cases where
one of the islands has zero species.}

\item{logT}{The log-transformation to apply to the area and richness values.
Can be any of \code{log}(default), \code{log2} or \code{log10}.}

\item{compare}{Fit the standard (non-linear) power model and return the
z-value for comparison (default: \code{compare = FALSE}).}

\item{normaTest}{The test used to test the normality of the residuals of the
model. Can be any of "lillie" (Lilliefors Kolmogorov-Smirnov test),
"shapiro" (Shapiro-Wilk test of normality), "kolmo" (Kolmogorov-Smirnov
test), or "none" (no residuals normality test is undertaken; the default).}

\item{homoTest}{The test used to check for homogeneity of the residuals of
the model. Can be any of "cor.fitted" (a correlation of the residuals with
the model fitted values), "cor.area" (a correlation of the residuals with
the area values), or "none" (no residuals homogeneity test is undertaken;
the default).}

\item{homoCor}{The correlation test to be used when \code{homoTest !=
"none"}. Can be any of "spearman" (the default), "pearson", or "kendall".}
}
\value{
A list of class "sars" with up to seven elements. The first element
  is an object of class 'summary.lm'. This is the summary of the linear model
  fit using the \link[stats]{lm} function and the user's data. The second
  element is a numeric vector of the model's fitted values, and the third
  contains the log-transformed observed data. The remaining elements depend
  on the function arguments selected and can include the results of the
  non-linear power model fit, the log-transformation function used (i.e.
  \code{logT}) and the results of any residuals normality and heterogeneity
  tests.

  The \code{\link{summary.sars}} function returns a more useful summary of
  the model fit results, and the \code{\link{plot.sars}} plots the model.
}
\description{
Fit the log-log version of the power model to SAR data and
  return parameter values, summary statistics and the fitted values.
}
\details{
A check is made for any islands with zero species. If any zero
  species islands are found, a constant (default: \code{con = 1}) is added to
  each species richness value to enable log transformation. Natural
  logarithms are used as default, but log2 and log10 can be used instead
  using the \code{logT} argument.

  The \code{compare} argument can be used to compare the c and z values
  calculated using the log-log power model with that calculated using the
  non-linear power model. Note that the log-log function returns log(c).
}
\examples{
data(galap)
fit <- lin_pow(galap, con = 1)
summary(fit)
plot(fit)
}
