% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{add_filter}
\alias{add_filter}
\title{Add a new filter}
\usage{
add_filter(
  name,
  query,
  color = NULL,
  is_favorite = FALSE,
  verbose = TRUE,
  token = get_todoist_api_token()
)
}
\arguments{
\item{name}{name of the filter}

\item{query}{filter query string (e.g., "today | overdue", "p1 & #Work")}

\item{color}{color of the filter}

\item{is_favorite}{boolean to mark as favorite}

\item{verbose}{boolean that make the function verbose}

\item{token}{todoist API token}
}
\value{
id of the new filter
}
\description{
Add a new filter
}
\examples{
\dontrun{
add_filter("Urgent Today", query = "today & p1")
add_filter("Work Tasks", query = "#Work", color = "blue")
}
}
