% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tile-math.R
\name{osm_tile}
\alias{osm_tile}
\alias{osm_tile_quadkey}
\alias{osm_tile_top_left}
\alias{osm_tile_envelope}
\title{Low-level tile math}
\usage{
osm_tile(pt, zoom)

osm_tile_quadkey(tile)

osm_tile_top_left(tile, crs = osm_crs_native())

osm_tile_envelope(tile, crs = osm_crs_native())
}
\arguments{
\item{pt}{A vector of points as coerced by [wk::as_xy()]. The CRS for these
points is considered.}

\item{zoom}{A zoom level, generally between 0 and 21, with higher values
representing a smaller (i.e., more detailed) tile.}

\item{tile}{A `data.frame()` with columns `x`, `y`, and `zoom`.}

\item{crs}{A target CRS. Either [wk::wk_crs_longlat()] or
[osm_crs_native()].}
}
\value{
- `osm_tile()`: A `data.frame()` with columns `x`, `y`, and `zoom`.
  - `osm_tile_top_left()`: A [wk::xy()] of the top-left (northwest) corner
    of the tile.
  - `osm_tile_envelope()`: A [wk::rct()] of the tile bounds.
}
\description{
Open Street Map operates using a system of tiles whose value and bounds
are easily calculated from WGS84 longitude/latitude. These functions convert
between tile system coordinates and longitude/latitude.
}
\examples{
(tiles <- osm_tile(osm_lnglat(-64, 45), zoom = 0:5))
osm_tile_envelope(tiles)

}
