% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_statis_phase2.R
\name{plot_statis_phase2_chart}
\alias{plot_statis_phase2_chart}
\title{Plot STATIS Dual Robust Control Chart - Phase 2 Only}
\usage{
plot_statis_phase2_chart(
  phase2_result,
  title = "Robust STATIS Dual Control Chart - Phase 2"
)
}
\arguments{
\item{phase2_result}{A list returned by \code{robust_statis_phase2()}, including
\code{t2_stats_by_batch} with Hotelling T² values and a control \code{threshold}.}

\item{title}{Optional string. Plot title.}
}
\value{
A ggplot2 object representing the control chart for Phase 2 batches.
}
\description{
Plots the robust Hotelling T² statistics for Phase 2 batches only,
using the results from the robust STATIS Dual method.
}
\examples{
sim_batches <- simulate_pharma_batches()
phase1 <- robust_statis_phase1(
  data = subset(sim_batches, Phase == "Phase 1" & Status == "Under Control"),
  variables = c("Concentration", "Humidity", "Dissolution", "Density")
)
phase2 <- robust_statis_phase2(
  new_data = subset(sim_batches, Phase == "Phase 2"),
  variables = c("Concentration", "Humidity", "Dissolution", "Density"),
  medians = phase1$global_medians,
  mads = phase1$global_mads,
  compromise_matrix = phase1$compromise_matrix,
  global_center = phase1$global_center
)
plot_statis_phase2_chart(phase2_result = phase2)
}
