% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_statis_biplot.R
\name{plot_statis_hj_biplot}
\alias{plot_statis_hj_biplot}
\title{HJ-Biplot of Robust STATIS Dual Compromise (Galindo-Villardón)}
\usage{
plot_statis_hj_biplot(
  phase1_result,
  dims = c(1, 2),
  color_by = c("none", "weight", "distance"),
  highlight_batches = NULL
)
}
\arguments{
\item{phase1_result}{Result from robust_statis_phase1().}

\item{dims}{Dimensions to plot (default: c(1, 2)).}

\item{color_by}{One of "none", "weight", or "distance" for coloring batches.}

\item{highlight_batches}{Optional vector of batch names to emphasize.}
}
\value{
ggplot2 object with HJ-Biplot.
}
\description{
Generates an HJ-Biplot using the compromise matrix obtained
from robust STATIS Dual. Individuals (batch centers) are projected as G = U D,
and variables as H = V D, where D is the diagonal matrix of square roots of eigenvalues.
}
\examples{
sim_batches <- simulate_pharma_batches()
phase1 <- robust_statis_phase1(
  data = subset(sim_batches, Phase == "Phase 1" & Status == "Under Control"),
  variables = c("Concentration", "Humidity", "Dissolution", "Density")
)
plot_statis_hj_biplot(phase1)
}
