% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{zmcomp2metconv}
\alias{zmcomp2metconv}
\title{Convert u/v to meteorological wind speed and direction}
\usage{
zmcomp2metconv(u, v = NULL, names = c("wspd", "wdir"))
}
\arguments{
\item{u}{zonal velocity (1D vector) or matrix with zonal and meridional velocity (Nx2 matrix)}

\item{v}{meridional velocity (1D vector)}

\item{names}{names to construct the resulting data.frame}
}
\value{
a Nx2 data.frame with the norm and direction (meteorological convention)
}
\description{
Converts wind or current zonal and meridional velocity components to
magnitude and direction according to meteorological convention.
}
\examples{
u <- matrix(rnorm(200), nrow = 100, ncol = 2)
vdir <- zmcomp2metconv(u)
}
