% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmdata.R
\name{get_osmdata}
\alias{get_osmdata}
\title{Retrieve OpenStreetMap data for a given location}
\usage{
get_osmdata(
  city_name,
  river_name,
  network_buffer = NULL,
  buildings_buffer = NULL,
  city_boundary = TRUE,
  crs = NULL,
  force_download = FALSE
)
}
\arguments{
\item{city_name}{The name of the city as character vector of length 1,
case-sensitive. Required, no default.}

\item{river_name}{The name of the river as character vector of length 1,
case-sensitive. Required, no default.}

\item{network_buffer}{Buffer distance in meters around the river
to get the streets and railways, default is 0 means no
network data will be downloaded}

\item{buildings_buffer}{Buffer distance in meters around the river
to get the buildings, default is 0 means no
buildings data will be downloaded}

\item{city_boundary}{A logical indicating if the city boundary should be
retrieved. Default is TRUE.}

\item{crs}{An integer or character vector of length one with the EPSG code
for the projection. If no CRS is specified, the default is the UTM zone
for the city.}

\item{force_download}{Download data even if cached data is available}
}
\value{
A list with the retrieved OpenStreetMap data sets for the
given location, as objects of class \code{\link[sf:sfc]{sf::sfc}}
}
\description{
Retrieve OpenStreetMap data for a given location, including
the city boundary, the river centreline and surface, the streets, the
railways, and the buildings
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Set parameters
city <- "Bucharest"
river <- "Dâmbovița"
crs <- "EPSG:31600"  # National projected CRS

# Get OSM data with defaults
get_osmdata(city_name = city, river_name = river)

# Get OSM data without city boundary
get_osmdata(city_name = city, river_name = river, city_boundary = FALSE)

# Use custom network buffer to get streets and railways
get_osmdata(city_name = city, river_name = river, network_buffer = 3500)

# Use custom buffer to get buildings
get_osmdata(city_name = city, river_name = river, buildings_buffer = 150)

# Use custom CRS
get_osmdata(city_name = city, river_name = river, crs = crs)

# Avoid getting OSM data from cache
get_osmdata(city_name = city, river_name = river, force_download = TRUE)
\dontshow{\}) # examplesIf}
}
