% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_noncircular.R
\name{expand_noncircular}
\alias{expand_noncircular}
\title{Expand non-circular}
\usage{
expand_noncircular(caim, z, zenith_colrow)
}
\arguments{
\item{caim}{\link[terra:SpatRaster-class]{terra::SpatRaster}. Typically the output of \code{\link[=read_caim]{read_caim()}}.}

\item{z}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=zenith_image]{zenith_image()}}.}

\item{zenith_colrow}{numeric vector of length two. Raster coordinates of the
zenith (column, row). See \code{\link[=calc_zenith_colrow]{calc_zenith_colrow()}}. Coordinates follow the
raster convention (column, row), not matrix order.}
}
\value{
\link[terra:SpatRaster-class]{terra::SpatRaster} with the same layers and pixel values as \code{caim},
but with \code{NA} margins added to center the zenith.
}
\description{
Add \code{NA} margins to a hemispherical photograph to align radiance at the zenith
with the image center. In this context, “zenith” denotes the location in the image
that corresponds to the projection of the vertical direction when the optical
axis is aligned vertically. Intended for non-circular images.
}
\note{
\code{rcaiman} uses terra without geographic semantics: rasters are kept with
unit resolution (cell size = 1) and a standardized extent
\code{ext(0, ncol, 0, nrow)} with CRS EPSG:7589.
}
\examples{
\dontrun{
# Non-circular fisheye images from a smartphone with an auxiliary Lens
# (also applicable to non-circular fisheye images from DSLR cameras)
path <- system.file("external/APC_0836.jpg", package = "rcaiman")
caim <- read_caim(path)
z <- zenith_image(2132/2,  lens("Olloclip"))
a <- azimuth_image(z)
zenith_colrow <- c(1063, 771)/2
caim <- expand_noncircular(caim, z, zenith_colrow)
plot(caim$Blue, col = seq(0, 1, 1/255) \%>\% grey())
m <- !is.na(caim$Red) & !is.na(z)
plot(m, add = TRUE, alpha = 0.3, legend = FALSE)
}
}
