% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BOW.R
\name{BOW_train}
\alias{BOW_train}
\title{Train a Bag-of-Words Model}
\usage{
BOW_train(doc, weighting_scheme = "bow", ngram_size = 1)
}
\arguments{
\item{doc}{A character vector of documents to be processed.}

\item{weighting_scheme}{A string specifying the weighting to apply.
Defaults to \code{"bag_of_words"}.
\itemize{
  \item \code{"bag_of_words"} (Alias: \code{"bow"}) - Standard count of words.
  \item \code{"term_frequency"} (Alias: \code{"tf"}) - Normalized counts (frequency relative to document length).
  \item \code{"tfidf"} (Alias: \code{"tf-idf"}) - Term Frequency-Inverse Document Frequency.
  \item \code{"binary"} - Presence/Absence (1/0).
}}

\item{ngram_size}{An integer specifying the maximum n-gram size. For example,
`ngram_size = 1` will create unigrams only; `ngram_size = 2` will create unigrams and bigrams. Defaults to 1.}
}
\value{
An object of class \code{"qs_bow_fit"} containing:
  \itemize{
    \item \code{dfm_template}: a quanteda \code{dfm} template
    \item \code{weighting_scheme}: the weighting used
    \item \code{ngram_size}: the n-gram size used
  }#'
}
\description{
Train a Bag-of-Words Model
}
\examples{
txt <- c("text one", "text two text")
fit <- BOW_train(txt, weighting_scheme = "bow")
fit$dfm_template

}
