% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrecTpFpMatrix.R
\name{PrecTpFpMatrix}
\alias{PrecTpFpMatrix}
\title{Compute Precision, True Positives, and False Positives}
\usage{
PrecTpFpMatrix(alpha, val.targets, all.orfs, tests, cand.reg, cis.cand.reg)
}
\arguments{
\item{alpha}{A numeric vector of significance levels.}

\item{val.targets}{A vector of validated target genes.}

\item{all.orfs}{A vector of all open reading frames (ORFs).}

\item{tests}{A list of test results for different methods.}

\item{cand.reg}{Candidate regions for QTL mapping.}

\item{cis.cand.reg}{Cis-regulatory candidate regions.}
}
\value{
A list of matrices containing precision, true positives, and false positives for each method and significance level.
}
\description{
The `PrecTpFpMatrix` function calculates precision, true positives, and false positives for various tests.
It is used to evaluate the performance of QTL mapping methods.
}
\examples{
\dontrun{
results <- PrecTpFpMatrix(alpha = seq(0.01, 0.1, by = 0.01),
                          val.targets = validated_genes,
                          all.orfs = all_genes,
                          tests = test_results,
                          cand.reg = candidate_regions,
                          cis.cand.reg = cis_regions)
}
}
