% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvEBayes_main_function.R
\name{.KM_fit}
\alias{.KM_fit}
\title{Fit a Koenker-Mizera (KM) model for a contingency table.}
\usage{
.KM_fit(N, E, rtol_KM = 1e-06)
}
\arguments{
\item{N}{an IxJ contingency table showing pairwise counts of
adverse events for I AEs (along the rows) and J drugs (along the columns).}

\item{E}{A matrix of expected counts under the null model for the SRS
frequency table.}

\item{rtol_KM}{The relative tolerance on the duality gap.}
}
\value{
a list of CVXR optimizer outputs
}
\description{
Fit a Koenker-Mizera (KM) model for a contingency table.
}
\details{
Parameter estimation for the "KM" model is formulated as a convex
optimization problem. The objective function and constraints used in
\pkg{pvEBayes} follow the same construction as in \pkg{REBayes}.
Parameter estimation is performed using the open-source convex optimization
package \pkg{CVXR}. The grid value generation follows the recommendation of
Tan et al. (2025).
}
\references{
Koenker R, Gu J. REBayes: an R package for empirical Bayes mixture methods.
\emph{Journal of Statistical Software}. 2017; 4;82:1-26.

Tan Y, Markatou M and Chakraborty S. Flexible Empirical Bayesian Approaches
to Pharmacovigilance for Simultaneous Signal Detection and Signal Strength
Estimation in Spontaneous Reporting Systems Data.
\emph{Statistics in Medicine.} 2025; 44: 18-19,
https://doi.org/10.1002/sim.70195.

Fu, A, Narasimhan, B, Boyd, S. CVXR: An R Package for Disciplined Convex
Optimization. \emph{Journal of Statistical Software}. 2020; 94;14:1-34.
}
\keyword{internal}
