% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.pubchem.ftp.R
\name{get.pubchem.ftp}
\alias{get.pubchem.ftp}
\title{get.pubchem.ftp}
\usage{
get.pubchem.ftp(
  pc.directory = NULL,
  timeout = 50000,
  rm.tmp.files = TRUE,
  threads = 2
)
}
\arguments{
\item{pc.directory}{character. directory to which data will be saved}

\item{timeout}{numeric.  timeout setting for FTP download.  setting options(timeout) value too small will generate errors for large files. default = 50000.}

\item{rm.tmp.files}{logical.  should temporary files be removed after completion of download and parsing?  Default = TRUE.}

\item{threads}{integer. the number of parallel threads to be used by foreach \%dopar\% during processing of taxonomy hierarchy data.}
}
\value{
nothing.  all data are saved to disk for later loading
}
\description{
first step to building a local selective, biologically focused, pubchem data repository focused on metabolomics informatics
}
\details{
this function downloads and unzips files from pubchem and NCBI taxonomy FTP sites as a first step in building a local metabolomics repository.
}
\examples{
\dontrun{
my.dir <- "C:/Temp/20250725"
# or some other valid directory.
# this will be created assuming 'C:/Temp' exists.
get.pubchem.ftp(
    pc.directory = my.dir,
    timeout = 50000,
    rm.tmp.files = TRUE
)
}

}
\author{
Corey Broeckling
}
