% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_survkm.R
\name{rwe_km}
\alias{rwe_km}
\title{Kaplan-Meier Estimation}
\usage{
rwe_km(
  dta_cur,
  dta_ext = NULL,
  n_borrow = 0,
  pred_tps = NULL,
  stderr_method = "naive"
)
}
\arguments{
\item{dta_cur}{Matrix of time and event from a PS stratum in the current
study}

\item{dta_ext}{Matrix of time and event from a PS stratum in the external
data source}

\item{n_borrow}{Number of subjects to be borrowed}

\item{pred_tps}{Time points to be estimated (unique and sorted)}

\item{stderr_method}{Method for computing StdErr (available for naive only)}
}
\value{
Estimation of survival probabilities at time \code{pred_tps}
}
\description{
Estimate survival probability based on Kaplan-Meier estimator for a single PS
stratum
}
