% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StudySpecificationUtilities.R
\name{.make_uoa_cluster_df}
\alias{.make_uoa_cluster_df}
\title{Make a dataframe that links units of assignment with clusters}
\usage{
.make_uoa_cluster_df(spec, cluster = NULL)
}
\arguments{
\item{spec}{A \code{StudySpecification} object.}

\item{cluster}{A character vector of column names to use as clusters.
Columns must exist in the dataframe used to create the
\code{StudySpecification} object. Defaults to NULL, in which case the
column names specified in the \code{unitid()},
\code{unit_of_assignment()}, or \code{cluster()} function in the
\code{StudySpecification} formula will be used.}
}
\value{
A dataframe where the number of rows coincides with the number of
distinct unit of assignment or cluster combinations (depending on whether
\code{cluster} is a more or less granular level than the assignment level) and
the columns correspond to the unit of assignment columns and a "cluster"
column
}
\description{
Make a dataframe that links units of assignment with clusters
}
\keyword{internal}
