% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova1way.c.unbal.R
\name{anova1way.c.unbal}
\alias{anova1way.c.unbal}
\title{Power calculation for one-way unbalanced analysis of variance contrast test}
\usage{
anova1way.c.unbal(
  nvec = NULL,
  mvec = NULL,
  cvec = NULL,
  sd = NULL,
  Rsq = 0,
  ncov = 0,
  alpha = 0.05,
  v = FALSE
)
}
\arguments{
\item{nvec}{A vector of group sample sizes c(n1, n2, ...).}

\item{mvec}{A vector of group mvec c(mu1, mu2, ...).}

\item{cvec}{A vector of contrast coefficients c(c1, c2, ...).}

\item{sd}{The estimated standard deviation within each group.}

\item{Rsq}{The estimated R^2 for regressing the outcome on the covariates; defaults to 0.}

\item{ncov}{The number of covariates adjusted for in the model; defaults to 0.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed power).
}
\description{
Calculates power for a test of a contrast in a one-way
ANOVA with unbalanced data (that is, unequal sized groups). This function
only solves for power. For a one-way balanced ANOVA,
(equal group sizes), anova1way.c.bal can also be used, and will solve for
quantities other than power.
}
\examples{
anova1way.c.unbal(nvec = c(20, 20, 20), mvec = c(5, 10, 12), cvec = c(1, -1, 0),
sd = 10, alpha = 0.025)
anova1way.c.unbal(nvec = c(20, 20, 20), mvec = c(5, 10, 12), cvec = c(1, 0, -1),
sd = 10, alpha = 0.025)
}
