% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhs_data_funs.R
\name{rhs_calc_nlmixr}
\alias{rhs_calc_nlmixr}
\title{Generate Right-hand side data (nlmixr2)}
\usage{
rhs_calc_nlmixr(
  rhs,
  inputs,
  est_parms = NULL,
  fit_obj = NULL,
  time_nn = NULL,
  act = NULL,
  beta = 20
)
}
\arguments{
\item{rhs}{(string) String of right-hand side, e.g., "NNc + WT * NNct"}

\item{inputs}{(dataframe) Dataframe of inputs, with corresponding columns (including matching column names 
for each variable in \emph{rhs}, e.g., NNc, WT, and NNct).}

\item{est_parms}{(named vector; semi-optional) Named vector of estimated parameters from the NN extracted through the \emph{pre_fixef_extractor_mlx} function. For optionality, see \strong{Details}.}

\item{fit_obj}{(nlmixr fit object; semi-optional) The fit-object from nlmixr2(...). For optionality, see \strong{Details}.}

\item{time_nn}{(boolean vector) Vector for each NN in \emph{rhs} defining whether the neural network is a time-dependent neural network or not. Default value for all NN is FALSE.}

\item{act}{(character vector) Vector for each NN in \emph{rhs} defining the activation function used in the NN. Default value for all NN is "ReLU".}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if any \emph{act} is softplus; Default to 20.}
}
\value{
Dataframe with columns for the inputs and the combined right-hand side data.
}
\description{
This functions allows to generate right-hand side data, i.e., combined derivative data of multiple NNs and base-R operations.
}
\details{
Either \emph{est_parms} or \emph{fit_obj} must be given. If both arguments are given, \emph{est_parms} is prioritized.
}
\author{
Dominic Bräm
}
\keyword{internal}
