% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{uuid}
\alias{uuid}
\title{Generate Version 7 UUIDs or Random UUIDs}
\usage{
uuid(n = 1, uppercase = FALSE, usetime = FALSE)
}
\arguments{
\item{n}{Integer. Number of UUIDs to generate. Default is \code{1}.}

\item{uppercase}{Logical. If \code{TRUE}, the generated UUIDs are returned in uppercase letters. Default is \code{FALSE}.}

\item{usetime}{Logical. If \code{TRUE}, generates Version 7 UUIDs using the current timestamp.
If \code{FALSE}, generates random Version 4 UUIDs. Default is \code{FALSE}.}
}
\value{
A character vector of UUIDs of length \code{n}.
}
\description{
This function generates one or more UUIDs (Universally Unique Identifiers).
By default, it generates Version 7 UUIDs, which are time-ordered and suitable
for use cases requiring efficient indexing and sorting by creation time.
Alternatively, random Version 4 UUIDs can be generated by setting \code{usetime = FALSE}.
}
\details{
\itemize{
\item \strong{Version 7 UUIDs}: These are time-ordered UUIDs based on the current timestamp in milliseconds
since the Unix epoch (\verb{1970-01-01 00:00:00 UTC}). They are ideal for scenarios requiring
chronological sorting or indexing.
\item \strong{Version 4 UUIDs}: These are randomly generated UUIDs that do not depend on time,
ensuring uniqueness through random hexadecimal values.
}
}
\examples{
library(pliman)
# Generate a single UUID
uuid()

# Generate 5 UUIDs in uppercase
uuid(n = 3, uppercase = TRUE)

# Generate two random UUIDs
uuid(n = 2, usetime = FALSE)

}
