% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EBIC.R, R/pbetareg.R, R/pcoxph.R, R/pglm.R,
%   R/plm.R, R/prq.R
\name{EBIC}
\alias{EBIC}
\alias{EBIC.betareg}
\alias{EBIC.coxph}
\alias{EBIC.glm}
\alias{EBIC.lm}
\alias{EBIC.rq}
\title{Extended Bayesian Information Criterion}
\usage{
EBIC(object, p, p.keep, ...)

\method{EBIC}{betareg}(object, p, p.keep, ...)

\method{EBIC}{coxph}(object, p, p.keep, ...)

\method{EBIC}{glm}(object, p, p.keep, ...)

\method{EBIC}{lm}(object, p, p.keep, ...)

\method{EBIC}{rq}(object, p, p.keep, ...)
}
\arguments{
\item{object}{Fitted model object.}

\item{p}{Total number of candidate features, which is available in \link{pboost}.}

\item{p.keep}{Number of features that are pre-specified to be kept in model.}

\item{...}{Additional parameters, which is available in \link{pboost}.}
}
\value{
A function to obtain the EBIC value of a fitted object.
}
\description{
The Extended BIC possesses the selection consistency in
high-dimensional model.

It can be called by the fitted model that has standard \link{logLik} method
to access the attributes \code{nobs} and \code{df}, such as \link{lm}, \link{glm}.
}
\details{
The extended BIC (EBIC) is defined as

\if{html}{\out{<div class="sourceCode">}}\preformatted{EBIC(obj) = BIC(obj) + 2 * r * log(choose(p - |p.keep|, df - |p.keep|)).
}\if{html}{\out{</div>}}
}
\references{
\itemize{
\item Jiahua Chen and Zehua Chen (2008). Extended Bayesian information criteria for
model selection with large model spaces. Biometrika, 95(3):759–771.
\doi{10.1093/biomet/asn034}
\item Jiahua Chen and Zehua Chen (2012). Extended BIC for small-n-large-p sparse GLM.
Statistical Sinica, 22(2):555–574. \doi{10.5705/ss.2010.216}
}
}
\seealso{
\link{plm}, \link{pglm}, \link{pcoxph}, \link{prq}, \link{pbetareg}.
}
