% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_batch_api.R
\name{gemini_download_batch_results}
\alias{gemini_download_batch_results}
\title{Download Gemini Batch results to a JSONL file}
\usage{
gemini_download_batch_results(
  batch,
  requests_tbl,
  output_path,
  api_key = Sys.getenv("GEMINI_API_KEY"),
  api_version = "v1beta"
)
}
\arguments{
\item{batch}{Either a parsed batch object (as returned by
\code{gemini_get_batch()}) or a character batch name such as
\code{"batches/123..."}.}

\item{requests_tbl}{Tibble/data frame with a \code{custom_id} column in the
same order as the submitted requests.}

\item{output_path}{Path to the JSONL file to create.}

\item{api_key}{Optional Gemini API key (used only when
\code{batch} is a name).}

\item{api_version}{API version (default \code{"v1beta"}).}
}
\value{
Invisibly returns \code{output_path}.
}
\description{
For inline batch requests, Gemini returns results under
\code{response$inlinedResponses$inlinedResponses}. In the v1beta REST API
this often comes back as a data frame with one row per request and a
\code{"response"} column, where each \code{"response"} is itself a data frame
of \code{GenerateContentResponse} objects.
}
\details{
This helper writes those results to a local \code{.jsonl} file where each
line is a JSON object of the form:

\preformatted{
{"custom_id": "<GEM_ID1_vs_ID2>",
 "result": {
   "type": "succeeded",
   "response": { ... GenerateContentResponse ... }
 }}
}

or, when an error occurred:

\preformatted{
{"custom_id": "<GEM_ID1_vs_ID2>",
 "result": {
   "type": "errored",
   "error": { ... }
 }}
}
}
\examples{
# This example requires a Gemini API key and network access.
# It assumes you have already created and run a Gemini batch job.
\dontrun{
# Name of an existing Gemini batch
batch_name <- "batches/123456"

# Requests table used to create the batch (must include custom_id)
requests_tbl <- tibble::tibble(
  custom_id = c("GEM_S01_vs_S02", "GEM_S03_vs_S04")
)

# Download inline batch results to a local JSONL file
out_file <- tempfile(fileext = ".jsonl")

gemini_download_batch_results(
  batch        = batch_name,
  requests_tbl = requests_tbl,
  output_path  = out_file
)

# Inspect the downloaded JSONL
readLines(out_file, warn = FALSE)
}

}
