% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bt_model.R
\name{fit_bt_model}
\alias{fit_bt_model}
\title{Fit a Bradley–Terry model with sirt and fallback to BradleyTerry2}
\usage{
fit_bt_model(
  bt_data,
  engine = c("auto", "sirt", "BradleyTerry2"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{bt_data}{A data frame or tibble with exactly three columns:
two character ID columns and one numeric \code{result} column
equal to 0 or 1. Usually produced by \code{\link{build_bt_data}}.}

\item{engine}{Character string specifying the modeling engine. One of:
\code{"auto"} (default), \code{"sirt"}, or \code{"BradleyTerry2"}.}

\item{verbose}{Logical. If \code{TRUE} (default), show engine output (iterations,
warnings). If \code{FALSE}, suppress noisy output to keep
examples and reports clean.}

\item{...}{Additional arguments passed through to \code{sirt::btm()}
or \code{BradleyTerry2::BTm()}.}
}
\value{
A list with the following elements:
\describe{
\item{engine}{The engine actually used ("sirt" or "BradleyTerry2").}
\item{fit}{The fitted model object.}
\item{theta}{
A tibble with columns:
\itemize{
\item \code{ID}: object identifier
\item \code{theta}: estimated ability parameter
\item \code{se}: standard error of \code{theta}
}
}
\item{reliability}{
MLE reliability (sirt engine only). \code{NA} for
\pkg{BradleyTerry2} models.
}
}
}
\description{
This function fits a Bradley–Terry paired-comparison model to data
prepared by \code{\link{build_bt_data}}. It supports two modeling
engines:
\itemize{
\item \pkg{sirt}: \code{\link[sirt]{btm}} — the preferred engine, which
produces ability estimates, standard errors, and MLE reliability.
\item \pkg{BradleyTerry2}: \code{\link[BradleyTerry2]{BTm}} — used as a
fallback if \pkg{sirt} is unavailable or fails; computes ability
estimates and standard errors, but not reliability.
}
}
\details{
When \code{engine = "auto"} (the default), the function attempts
\pkg{sirt} first and automatically falls back to \pkg{BradleyTerry2}
only if necessary. In all cases, the output format is standardized, so
downstream code can rely on consistent fields.

The input \code{bt_data} must contain exactly three columns:
\enumerate{
\item object1: character ID for the first item in the pair
\item object2: character ID for the second item
\item result: numeric indicator (1 = object1 wins, 0 = object2 wins)
}

Ability estimates (\code{theta}) represent latent "writing quality"
parameters on a log-odds scale. Standard errors are included for both
modeling engines. MLE reliability is only available from \pkg{sirt}.
}
\examples{
# Example using built-in comparison data
data("example_writing_pairs")
bt <- build_bt_data(example_writing_pairs)

fit1 <- fit_bt_model(bt, engine = "sirt")
fit2 <- fit_bt_model(bt, engine = "BradleyTerry2")

}
