% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pecv_miss.R
\name{generate_continuous_data_miss}
\alias{generate_continuous_data_miss}
\title{Generate continuous data with missing values}
\usage{
generate_continuous_data_miss(
  n = 100,
  p = 50,
  q = 3,
  noise_sd = 1,
  miss_prop = 0.05
)
}
\arguments{
\item{n}{Integer. Number of observations.}

\item{p}{Integer. Number of variables.}

\item{q}{Integer. True number of latent factors.}

\item{noise_sd}{Numeric. Standard deviation of Gaussian noise.}

\item{miss_prop}{Numeric in (0,1). Proportion of missing values (default 0.05).}
}
\value{
A named list with components:
\describe{
  \item{resp}{Numeric matrix (n x p). Generated data with missing values (NA).}
  \item{resp_complete}{Numeric matrix (n x p). Complete data before missingness.}
  \item{true_q}{Integer. True number of factors used in simulation.}
  \item{theta_true}{Numeric matrix (n x (q+1)). True latent factor scores with intercept.}
  \item{A_true}{Numeric matrix (p x (q+1)). True factor loadings.}
  \item{miss_prop}{Numeric. Proportion of entries set to missing.}
}
}
\description{
Generate simulated data from a Gaussian factor model with missing values.
}
