% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_map_notes.R
\name{osm_search_notes}
\alias{osm_search_notes}
\title{Search for notes}
\usage{
osm_search_notes(
  q,
  user,
  bbox,
  from,
  to,
  closed = 7,
  sort = c("created_at", "updated_at"),
  order = c("newest", "oldest"),
  limit = getOption("osmapir.api_capabilities")$api$notes["default_query_limit"],
  format = c("R", "sf", "xml", "rss", "json", "gpx")
)
}
\arguments{
\item{q}{Text search query, matching either note text or comments.}

\item{user}{Search for notes which the given user interacted with. The value can be the user id (\code{numeric}) or the
display name (\code{character}).}

\item{bbox}{Search area expressed as a string or a numeric vector of 4 coordinates of a valid bounding box
(\verb{left,bottom,right,top}) in decimal degrees. It can be specified by a character, matrix, vector, \code{bbox} object
from \pkg{sf}, a \code{SpatExtent} from \pkg{terra}. Unnamed vectors and matrices will be sorted appropriately and must
merely be in the order (\code{x}, \code{y}, \code{x}, \code{y}) or \code{x} in the first column and \code{y} in the second column. Area must be
at most 25 square degrees (see \code{osm_capabilities()$note_area} and
\href{https://github.com/openstreetmap/openstreetmap-website/blob/master/config/settings.yml#L27}{this line in settings}
for the current value).}

\item{from}{Beginning date range for \code{created_at} or \code{updated_at} (specified by \code{sort}). Preferably in
\href{https://en.wikipedia.org/wiki/ISO_8601}{ISO 8601} date format.}

\item{to}{End date range for \code{created_at} or \code{updated_at} (specified by \code{sort}). Preferably in
\href{https://en.wikipedia.org/wiki/ISO_8601}{ISO 8601} date format. Only works when \code{from} is supplied.}

\item{closed}{Specifies the number of days a note needs to be closed to no longer be returned. A value of 0 means
only open notes are returned. A value of -1 means all notes are returned. 7 is the default.}

\item{sort}{Sort results by creation (\code{"created_at"}, the default) or update date (\code{"updated_at"}).}

\item{order}{Sorting order. \code{"oldest"} is ascending order, \code{"newest"} is descending order (the default).}

\item{limit}{Maximum number of results between 1 and 10000 (may change, see \code{osm_capabilities()$api$notes} for the
current value). Default to 100.}

\item{format}{Format of the the returned list of notes. Can be \code{"R"} (default), \code{"sf"}, \code{"xml"}, \code{"rss"}, \code{"json"} or
\code{"gpx"}.}
}
\value{
If \code{format = "R"}, returns a data frame with one map note per row. If \code{format = "sf"}, returns a \code{sf} object from
\pkg{sf}. If \code{format = "json"}, returns a list with the json structure. For \code{format} in \code{"xml"}, \code{"rss"}, and
\code{"gpx"}, a \link[xml2:oldclass]{xml2::xml_document} with the corresponding format.
}
\description{
Returns notes that match the specified query. If no query is provided, the most recently updated notes are returned.
}
\details{
The notes will be ordered by the date of their last change, the most recent one will be first.
}
\examples{
notes <- osm_search_notes(
  q = "POI", bbox = "0.1594133,40.5229822,3.3222508,42.8615226",
  from = "2017-10-01", to = "2018-10-27T15:27A", limit = 10
)
notes

my_notes <- osm_search_notes(
  user = "jmaspons", bbox = c(-0.1594133, 40.5229822, 3.322251, 42.861523),
  closed = -1, format = "json"
)
my_notes
}
\seealso{
Other get notes' functions: 
\code{\link{osm_feed_notes}()},
\code{\link{osm_get_notes}()},
\code{\link{osm_read_bbox_notes}()}
}
\concept{get notes' functions}
