% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-person.R
\name{orcid_external_identifiers}
\alias{orcid_external_identifiers}
\title{Retrieve external identifiers from ORCID}
\usage{
orcid_external_identifiers(orcid_id, token = NULL)
}
\arguments{
\item{orcid_id}{Character string. A valid ORCID identifier in the format
XXXX-XXXX-XXXX-XXXX. Can also handle URLs like https://orcid.org/XXXX-XXXX-XXXX-XXXX.}

\item{token}{Character string or NULL. Optional API token for authenticated
requests. If NULL (default), checks the ORCID_TOKEN environment variable.}
}
\value{
A data.table with the following columns:
\describe{
\item{orcid}{ORCID identifier}
\item{put_code}{Unique identifier for this external ID}
\item{external_id_type}{Type of external identifier (e.g., "Scopus Author ID")}
\item{external_id_value}{The identifier value}
\item{external_id_url}{URL to the external profile (if available)}
}
Returns an empty data.table with the same structure if no external
identifiers are found.
}
\description{
Fetches external identifier mappings for an ORCID record, such as Scopus
Author ID, ResearcherID, Loop profile, and other researcher identification
systems.
}
\details{
This function queries the ORCID public API endpoint:
\code{https://pub.orcid.org/v3.0/{orcid-id}/external-identifiers}
}
\examples{
\dontrun{
# Fetch external identifiers
ext_ids <- orcid_external_identifiers("0000-0002-1825-0097")
print(ext_ids)
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
\code{\link{orcid_person}}
}
