# ODBC Resource R

[![R-CMD-check](https://github.com/obiba/odbc.resourcer/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/obiba/odbc.resourcer/actions/workflows/R-CMD-check.yaml)
[![CRAN_Status_Badge](http://www.r-pkg.org/badges/version/odbc.resourcer)](https://cran.r-project.org/package=odbc.resourcer)

The `odbc.resourcer` package is for accessing databases implementing the ODBC API.

For a [MS SQL](https://www.microsoft.com/en-us/sql-server/sql-server-2022) server database, the resource object would be:

```r
library(odbc.resourcer)
# Create a resource
res <- resourcer::newResource(url = "odbc+mssql://localhost:1433/EpidemiologyDB/PatientData", identity = "sa", secret = "YourStrong@Password123")
# Create a resource client
client <- resourcer::newResourceClient(res)
# Coerce resource to a data frame
df <- client$asDataFrame()
# Disconnect the client
client$close()
```

The package is built on top of the [odbc](https://CRAN.R-project.org/package=odbc) package and the [DBI](https://CRAN.R-project.org/package=DBI) package.
